/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.entity.projectile;

import dev.toma.gunsrpg.common.entity.projectile.AbstractProjectile;
import dev.toma.gunsrpg.common.entity.projectile.IReaction;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;

public class NapalmReaction
implements IReaction {
    public static final IReaction NAPALM = new NapalmReaction(8.0, 0.25f);
    private final double range;
    private final float factor;

    public NapalmReaction(double range, float factor) {
        this.range = range;
        this.factor = factor;
    }

    @Override
    public void react(AbstractProjectile projectile, Vector3d impact, World world) {
        if (world.field_72995_K) {
            return;
        }
        int irange = (int)Math.ceil(this.range);
        int half = irange / 2;
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        for (int x = -half; x <= half; ++x) {
            for (int z = -half; z <= half; ++z) {
                int posX = (int)(impact.field_72450_a + (double)x);
                int posZ = (int)(impact.field_72449_c + (double)z);
                int posY = world.func_201676_a(Heightmap.Type.WORLD_SURFACE, posX, posZ);
                BlockPos pos2 = new BlockPos(posX, posY, posZ);
                positions.add(pos2);
            }
        }
        Random random = world.field_73012_v;
        positions.stream().filter(pos -> random.nextDouble() < (double)this.factor && this.distance((BlockPos)pos, impact) <= this.range).forEach(pos -> world.func_180501_a(pos, Blocks.field_150480_ab.func_176223_P(), 3));
    }

    private double distance(BlockPos pos, Vector3d vec) {
        double x = (double)pos.func_177958_n() - vec.field_72450_a;
        double y = (double)pos.func_177956_o() - vec.field_72448_b;
        double z = (double)pos.func_177952_p() - vec.field_72449_c;
        return Math.sqrt(x * x + y * y + z * z);
    }
}

